'/***
'*mbctype.h - MBCS character conversion macros
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation.  All rights reserved.
'*
'*Purpose:
'*       Defines macros for MBCS character classification/conversion.
'*
'*       [Public]
'*
'****/

#If Not %Def(%MBCTYPE_INC)
    %MBCTYPE_INC = 1

'/* include the standard ctype.h header file */

#Include "ctype.inc"

'/*
' * MBCS - Multi-Byte Character Set
' */

'/*
' * This declaration allows the user access the _mbctype[] look-up array.
' */

'_CRTIMP extern unsigned char _mbctype[];
Function pb_mbctype () As Dword
   Local hLib As Dword
   Local pmbctype As Word Ptr
   hLib = LoadLibrary("msvcrt.dll")
   If hLib Then
      pmbctype = GetProcAddress(hLib, "_mbctype")
      Function = pmbctype
      FreeLibrary hLib
   End If
End Function

'_CRTIMP extern unsigned char _mbcasemap[];
Function pb_mbcasemap () As Dword
   Local hLib As Dword
   Local pmbcasemap As Word Ptr
   hLib = LoadLibrary("msvcrt.dll")
   If hLib Then
      pmbcasemap = GetProcAddress(hLib, "_mbcasemap")
      Function = pmbcasemap
      FreeLibrary hLib
   End If
End Function


'/* bit masks for MBCS character types */

%MS_     = &H01    ' /* MBCS single-byte symbol */
%MP_     = &H02    ' /* MBCS punct */
%M1_     = &H04    ' /* MBCS 1st (lead) byte */
%M2_     = &H08    ' /* MBCS 2nd byte*/

%SBUP_   = &H10    ' /* SBCS upper char */
%SBLOW_  = &H20    ' /* SBCS lower char */

'/* byte types  */

%MBC_SINGLE    = 0       ' /* valid single byte char */
%MBC_LEAD      = 1       ' /* lead byte */
%MBC_TRAIL     = 2       ' /* trailing byte */
%MBC_ILLEGAL   = -1      ' /* illegal byte */

%KANJI_CP  = 932

'/* _setmbcp parameter defines */
%MB_CP_SBCS    = 0
%MB_CP_OEM     = -2
%MB_CP_ANSI    = -3
%MB_CP_LOCALE  = -4


#If Not %Def(%MBCTYPE_DEFINED)
%MBCTYPE_DEFINED = 1

'/* MB control routines */

'_CRTIMP int __cdecl _setmbcp(int);
Declare Function setmbcp CDecl Lib "msvcrt.dll" Alias "_setmbcp" ( _
   ByVal Long _                             ' int codepage
   ) As Long                                ' int

'_CRTIMP int __cdecl _getmbcp(void);
Declare Function getmbcp CDecl Lib "msvcrt.dll" Alias "_getmbcp" ( _
   ) As Long                                ' int


'/* MBCS character classification function prototypes */


'/* byte routines */

'_CRTIMP int __cdecl _ismbbkalnum( unsigned int );
Declare Function ismbbkalnum CDecl Lib "msvcrt.dll" Alias "_ismbbkalnum" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbbkana( unsigned int );
Declare Function ismbbkana CDecl Lib "msvcrt.dll" Alias "_ismbbkana" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbbkpunct( unsigned int );
Declare Function ismbbkpunct CDecl Lib "msvcrt.dll" Alias "_ismbbkpunct" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbbkprint( unsigned int );
Declare Function ismbbkprint CDecl Lib "msvcrt.dll" Alias "_ismbbkprint" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbbalpha( unsigned int );
Declare Function ismbbalpha CDecl Lib "msvcrt.dll" Alias "_ismbbalpha" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbbpunct( unsigned int );
Declare Function ismbbpunct CDecl Lib "msvcrt.dll" Alias "_ismbbpunct" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbbalnum( unsigned int );
Declare Function ismbbalnum CDecl Lib "msvcrt.dll" Alias "_ismbbalnum" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbbprint( unsigned int );
Declare Function ismbbprint CDecl Lib "msvcrt.dll" Alias "_ismbbprint" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

_CRTIMP Int __cdecl _ismbbgraph( unsigned Int );
Declare Function ismbbgraph CDecl Lib "msvcrt.dll" Alias "_ismbbgraph" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int


#If Not %Def(%MBLEADTRAIL_DEFINED)
%MBLEADTRAIL_DEFINED = 1

'_CRTIMP int __cdecl _ismbblead( unsigned int );
Declare Function ismbblead CDecl Lib "msvcrt.dll" Alias "_ismbblead" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbbtrail( unsigned int );
Declare Function ismbbtrail CDecl Lib "msvcrt.dll" Alias "_ismbbtrail" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbslead( const unsigned char *, const unsigned char *);
Declare Function ismbslead CDecl Lib "msvcrt.dll" Alias "_ismbslead" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbstrail( const unsigned char *, const unsigned char *);
Declare Function ismbstrail CDecl Lib "msvcrt.dll" Alias "_ismbstrail" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

#EndIf   ' #IF NOT %DEF(%MBLEADTRAIL_DEFINED)


#EndIf   ' #IF NOT %DEF(%MBCTYPE_DEFINED)


#EndIf   ' #IF NOT %DEF(%MBCTYPE_INC)